//
//  BIDocument.h
//  BIViews
//
//  Created by Eric Hochmeister on 23/12/04.
//  Copyright 2004 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <MCApplication/MCDocument.h>

@class BIQueryHandler, BIUser;
@class BITimeSlip;
@class BIEstimateSlip;
@class BIProject;
@class BITimeSlipType;
@class BIEstimate;
@class BIClient;
@class BITimerWindow;
@class BIPayment;
@class BIRetainer;
@class BIStatement;
@class BIInvoice;
@class BIProFormaInvoice;
@class BINote;
@class BIURLReference;
@class BIRecurringInvoice;
@class MCUserDefaults;
@class ABPerson;
@class MCMetaDataManager;
@class BISlipTemplate;
@class BICreationContext;
@class BIUpdateDatabaseWindow;
@class BIProjectPickerSheet;
@class BIPrimeWindowController;
@class BIDatabaseObjectContext;
@class BIAllClientsSummary;
@class DayliteContactContainer;
@class MCPDatabaseConnection;

#if ! BILLINGS_PRO
@class BITouchSyncController;
#endif

@interface BIDocument : MCDocument {

	BIDatabaseObjectContext* _context;
	MCPDatabaseConnection* _dbConn;
#if ! BILLINGS_PRO
	BITouchSyncController* _touchSyncController;
#endif
	
	BIUser* _primaryUser;
	
	NSArray* _projectStages;
	NSArray* _projectStates;
	NSArray* _timeSlipTypes;
	
	NSArray* _sleptSlips;
	
	BITimerWindow* _timerWindow;
	
	MCMetaDataManager *_metaDataManager;
	
	NSTimer *hourlyTimer;
	
#ifdef BILLINGS_PRO
	NSTimer *syncWatchTimer;
	NSTimer *syncRestartTimer;
    NSTimer *versionTimer;
#endif	
}

+ (BOOL)createBillingsFolders;

+ (BIDocument *)sharedDocument;
+ (BOOL)closeSharedDocument;
+ (BOOL)openSharedDocumentAtPath:(NSString *)path;
+ (BOOL)openSharedDocument;

/*!
 Used for hiding stuff in nibs with bindings
 */
- (BOOL)isBillingsPro;
- (MCUserDefaults *)userDefaults;

- (NSImage *)logoImage;
- (void)setLogoImageFromPath:(NSString *)path;
- (void)fixLogoImageIfOverMaxSize;

- (NSNumber*)databaseSchemaNumber;
- (BOOL)shouldUpdateDatabaseSchema;
- (void)updateDatabaseSchemaFromSchema:(NSNumber*)dbSchema;
- (void)updateDatabaseSchemaFromSchema:(NSNumber*)dbSchemaNum showProgressWindow:(BOOL)show;

- (NSString*)databaseUUID;

- (void)configureDocumentForFile:(NSString *)path;
- (BOOL)openFile:(NSString *)path;
- (void)openTaxFile:(NSString*)aPath;
- (void)openObject:(id)obj;

// Address Book syncing
- (void)refreshClients;
- (void)handleAddressBookChanged:(NSNotification *)notif;
- (void)addressBookChanged:(NSNotification *)notif;

- (NSDictionary *)startTimerHotKeyConfiguration;
- (NSDictionary *)toggleTimerWindowHotKeyConfiguration;

- (void)registerStartTimerHotKey;
- (void)registerToggleTimerWindowHotKey;

- (void)handleStartTimerFromGlobalHotKey:(id)hotKeyConfig;
- (void)handleToggleTimerWindowFromGlobalHotKey:(id)hotKeyConfig;

- (BITimerWindow*)timerWindow;
- (void)setTimerWindow:(BITimerWindow*)aController;


- (BIDatabaseObjectContext*)objectContext;
- (void)setObjectContext:(BIDatabaseObjectContext*)context;

- (void)setDatabaseConnection:(MCPDatabaseConnection *)conn;
- (MCPDatabaseConnection *)databaseConnection;

- (BICreationContext*)objectCreationHandler;

- (BIQueryHandler*)queryHandler;

- (BIUser*)currentUser;
- (BIUser*)primaryUser;
- (void)setPrimaryUser:(BIUser*)aUser;

- (void)showProjectWindowAndCreateProject:(BIProject*)aProject forClient:(BIClient*)aClient;
- (id)showProjectWindowAndEditProject:(BIProject*)aProject forClient:(BIClient*)aClient;
- (id)showProjectWindowAndEditProject:(BIProject*)aProject;
- (id)showProjectWindowAndShowNote:(BINote *)aNote;
- (id)showProjectWindowAndShowLink:(BIURLReference *)aLink;
- (void)showProjectInList:(BIProject *)aProject;
- (void)showTimeSlipInList:(BITimeSlip *)aSlip;
- (void)showEstimateSlipInList:(BIEstimateSlip *)aSlip;

- (ABPerson *)abPersonForClient:(BIClient *)aClient;
- (void)showClientInAddressBook:(BIClient *)aClient;

- (BOOL)isWindowOpenOfClass:(Class)aWindowController;

- (void)showSlipTemplateWindowAndCreateSlipTemplate;
- (void)showSlipTemplateWindowAndEditSlipTemplate:(BISlipTemplate*)aTemplate;

- (void)showTimeSlipWindowAndCreateTimeSlipOfType:(BITimeSlipType*)aType 
										forParent:(id)aParent
									 withTemplate:(BISlipTemplate*)aTemplate;

- (id)showTimeSlipWindowAndEditTimeSlip:(id)aTimeSlip withParent:(id)aParent isEditable:(BOOL)aFlag;
- (id)showTimeSlipWindowAndEditTimeSlip:(id)aTimeSlip withParent:(id)aParent;

- (void)showEstimateSlipWindowAndCreateSlipOfType:(BITimeSlipType*)aType 
										forParent:(id)aParent
									 withTemplate:(BISlipTemplate*)aTemplate;
- (void)showEstimateSlipWindowAndEditSlip:(id)aTimeSlip withParent:(id)aParent;

- (void)showClientDetailsWindowAndCreateClient;
- (void)showClientDetailsWindowForClient:(BIClient*)aClient;

- (void)showEstimateWindowAndCreateEstimateForProject:(BIProject*)aProject;
- (void)showEstimateWindowAndEditEstimate:(BIEstimate*)anEstimate forProject:(BIProject*)aProject;
- (void)showEstimatePDFforEstimate:(BIEstimate *)anEstimate;

- (void)showPaymentWindowAndCreatePaymentForClient:(BIClient*)aClient linkToInvoices:(NSArray*)theInvoices;
- (void)showPaymentWindowAndEditPayment:(BIPayment*)aPayment;

- (void)showRetainerWindowAndCreateRetainerForClient:(BIClient*)aClient;
- (void)showRetainerWindowAndEditRetainer:(BIRetainer*)aRetainer;

//- (void)showInvoiceWindowAndCreateInvoiceForProject:(BIProject*)aProject;
- (id)showInvoiceWindowAndEditInvoice:(BIInvoice*)anInvoice;
- (id)showInvoiceWindowAndShowSlip:(BITimeSlip*)aSlip;

- (void)showTimerWindow;
- (void)toggleTimerWindow;
- (void)loadTimerWindow;

- (void)showMainWindow;
- (void)closeAllWindows;

- (void)showCreateStatementWindowForClient:(BIClient*)aClient;
- (void)showStatementPDFforStatement:(BIStatement *)aStatement;

- (void)showCreateEstimateWindowForProject:(BIProject*)aProject withSlips:(NSArray*)theSlips;

- (void)showCreateInvoiceWindowForProFormaInvoice:(BIProFormaInvoice *)aProFormaInvoice;
- (void)showCreateInvoiceWindowForClient:(BIClient*)aClient;
- (void)showCreateInvoiceWindowForProject:(BIProject*)aProject withSlips:(NSArray*)theSlips;
- (void)showCreateInvoiceWindowForProject:(BIProject*)aProject 
								withSlips:(NSArray*)theSlips
								 delegate:(id)aDelegate
						   didEndSelector:(SEL)aSelector;
- (void)showCreateInvoiceWindowForProject:(BIProject*)aProject 
								withSlips:(NSArray*)theSlips
									 mode:(int)aMode
								 delegate:(id)aDelegate
						   didEndSelector:(SEL)aSelector;


- (void)showCreateInvoiceWindowWithRecurringInvoice:(BIRecurringInvoice *)aRecurringInvoice mode:(NSInteger)aMode;

- (void)showImportProjectOrOpportunityFromDayliteForContactContainer:(DayliteContactContainer*)contact_container 
															  client:(BIClient *)aClient;
- (void)showClientInDaylite:(BIClient *)aClient;

- (void)emailInvoicePDF:(BIInvoice *)anInvoice;
- (NSString *)filePathForInvoice:(BIInvoice *)anInvoice;

- (void)showRecurringInvoiceWindowAndCreateRecurringInvoice;
- (void)showRecurringInvoiceWindowAndEditRecurringInvoice:(BIRecurringInvoice*)aRecurringInvoice;

- (void)addNoteForProjects:(NSArray *)projects selectedProject:(BIProject *)aProject;

- (void)addWebURLForProjects:(NSArray*)projects selectedProject:(BIProject*)aProject;

- (BIPrimeWindowController *)primeWindowController;

- (MCMetaDataManager *)metaDataManager;
- (void)setMetaDataManager:(MCMetaDataManager *)aMetaDataManager;

#pragma mark Notification Methods
- (void)handleApplicationWillTerminate:(NSNotification*)aNotif;


- (IBAction)runRegisterSheet: (id)sender;
- (void)showRegisterRemindWindow;

// new update schema code
- (NSArray*)findAllUpdateScriptsToApplyUsingDBSchemaFilename:(NSString*)dbSchemaFilename 
                                           appSchemaFilename:(NSString*)appSchemaFilename;

//Filehandle will be set with the path of the backup being created
- (BOOL)backupDatabaseToPath:(NSString *)aPath archivePath:(NSString **)fileHandle;
- (BOOL)backupDatabaseArchivePath:(NSString **)fileHandle;
- (BOOL)backupDatabaseToPath:(NSString*)aPath;
- (BOOL)backupDatabase;

// Will only restore if no Database folder detected
+ (BOOL)restoreDatabaseFromBackup:(NSString *)backupPath;

- (void)applyUpdateScripts:(NSArray*)theScripts
    updateWindowController:(BIUpdateDatabaseWindow*)updateWindowCtl;

- (NSArray*)extractMCObjCCommandsAndApplyScript:(NSString*)aString;

// Menu Stuff
- (IBAction)openSelected:(id)sender;
- (IBAction)exportSelected:(id)sender;
- (IBAction)backup:(id)sender;
- (IBAction)restoreBackup:(id)sender;

- (IBAction)importBillingsExportFile:(id)sender;
- (void)importBillingsExportFileDidEnd:(NSOpenPanel*)sheet
                            returnCode:(int)returnCode
                           contextInfo:(void *)contextInfo;
- (void)importBillingsExportFileWithFilename:(NSString*)aFilename;
- (void)importSlipsWithFilename:(NSString*)aFilename;
//- (void)importSlipsProjectPickerSheetDidEnd:(NSWindow*)sheet
//                                 returnCode:(int)returnCode
//                                contextInfo:(void*)contextInfo;

- (void)importSlipOfEntityNamed:(NSString*)entityName 
              bexRepresentation:(NSDictionary*)aDict 
                        project:(BIProject*)aProject;

- (void)importEstimateSlipFromPlist:(NSDictionary*)aDict forProject:(BIProject*)aProject;
- (void)importTimeSlipFromPlist:(NSDictionary*)aDict forProject:(BIProject*)aProject;

//- (void)importEstimateSlipsFromPlist:(NSArray*)slips forProject:(BIProject*)aProject;
//- (void)importTimeSlipsFromPlist:(NSArray*)slips forProject:(BIProject*)aProject;
- (void)importProject:(BIProject*)aProject 
withBEXRepresentation:(NSDictionary*)projDict
            forClient:(BIClient*)aClient;

- (void)importVCardWithFilename:(NSString *)aPath;

- (BOOL)projectsImportIncludesEstimateSlips:(NSArray*)theProjects;
- (BOOL)projectsImportIncludesTimeSlips:(NSArray*)theProjects;

- (void)setTimeSlipLastImportDate:(NSCalendarDate*)importDate;
- (void)setProjectLastImportDate:(NSCalendarDate*)importDate;
- (void)setEstimateSlipLastImportDate:(NSCalendarDate*)importDate;

- (void)updateAppIcon;
- (int)recurringInvoicePastDueCount;
- (BOOL)isActiveTimedSlips;

- (BIAllClientsSummary *)allClientsSummary;

#ifdef BILLINGS_PRO

- (BOOL)isHosted;
- (NSString *)cloudID;
- (IBAction)checkCloudStatus:(id)sender;

- (void)showPreferencePaneWithIdentifier:(NSString *)aIdent;
- (void)showWelcomeWindowHideLaunchOption:(BOOL)hideLaunchFlag;
- (IBAction)showWelcomeWindow:(id)sender;

- (IBAction)showSendToMoneyWorks:(id)sender;
- (IBAction)showAddClientFromMoneyWorks:(id)sender;
- (void)showClientInMoneyWorks:(BIClient *)aClient;

- (IBAction)showSendToQuickBooks:(id)sender;
- (IBAction)showSendToAccountEdge:(id)sender;
- (void)completeMakeWindowControllersFirstRun:(BOOL)firstRun;

- (IBAction)presentClearCacheDialogue:(id)sender;
- (void)clearAndRecalculateCacheValues:(id)sender;

#endif


@end

@interface BIDocument (ScriptHandling)
- (void)runFScriptAtPath:(NSString *)aPath;
@end

